/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.io.navigator;

import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.ui.io.navigator.DeferredTreeContentManager;
import com.aptana.ide.ui.io.navigator.DeferredTreeSelectionExpander;
import com.aptana.ide.ui.io.navigator.FileTreeDeferredContentProvider;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class FileTreeContentProvider
implements ITreeContentProvider {
    protected static final String SELECTION_EXPANDER_KEY = "deferred_selection_expander";
    protected static final String CONTENT_PROVIDER_KEY = "deferred_content_provider";
    private static final Object[] EMPTY = new Object[0];
    private ITreeContentProvider delegateContentProvider;

    public Object[] getChildren(Object parentElement) {
        if (this.delegateContentProvider != null) {
            return this.delegateContentProvider.getChildren(parentElement);
        }
        return EMPTY;
    }

    public Object getParent(Object element) {
        if (this.delegateContentProvider != null) {
            return this.delegateContentProvider.getParent(element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (this.delegateContentProvider != null) {
            return this.delegateContentProvider.hasChildren(element);
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IWorkspaceRoot) {
            inputElement = CoreIOPlugin.getConnectionPointManager();
        }
        if (this.delegateContentProvider != null) {
            return this.delegateContentProvider.getElements(inputElement);
        }
        return EMPTY;
    }

    public void dispose() {
        if (this.delegateContentProvider != null) {
            this.delegateContentProvider.dispose();
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.delegateContentProvider == null && viewer instanceof AbstractTreeViewer) {
            AbstractTreeViewer treeViewer = (AbstractTreeViewer)viewer;
            this.delegateContentProvider = (ITreeContentProvider)viewer.getData(CONTENT_PROVIDER_KEY);
            if (this.delegateContentProvider == null) {
                DeferredTreeContentManager contentManager = new DeferredTreeContentManager(treeViewer);
                this.delegateContentProvider = new FileTreeDeferredContentProvider(contentManager);
                treeViewer.setData(CONTENT_PROVIDER_KEY, (Object)this.delegateContentProvider);
                DeferredTreeSelectionExpander selectionExpander = new DeferredTreeSelectionExpander(contentManager, treeViewer);
                treeViewer.setData(SELECTION_EXPANDER_KEY, (Object)selectionExpander);
            }
        }
    }
}

